
$(document).ready(function() {
    var swiper = new Swiper('.banner-slider', {
        autoplay: {
            delay: 3000,
            disableOnInteraction: false,
        },
        effect: 'fade',
        loop: true,
    });
});

$(document).on('mouseenter', '.menu-item-has-children', function (event) {
    $(this).find('.sub-menu').addClass('open');
}).on('mouseleave', '.menu-item-has-children', function (event) {
    $(this).find('.sub-menu').removeClass('open');
});
var $portfoSlider;
$(document).ready(function () {
    $portfoSlider = new Swiper('.portfolio-content-slider', {
        speed: 500,
        simulateTouch: false,
        allowTouchMove: false,
        effect: 'fade',
        fadeEffect: {
            crossFade: true,
        },
        /* flipEffect: {
            rotate: 30,
            slideShadows: false,
        }, */
        pagination: {
            el: '.portfolio-selectors',
            type: 'bullets',
            clickable: true,
            bulletElement: 'li',
            bulletClass: 'portfolio-selector-bullet',
            bulletActiveClass: 'portfolio-selector-bullet-active',
            modifierClass: 'portfolio-selector-',
            currentClass: 'portfolio-selector-current',
            totalClass: 'portfolio-selector-total',
            hiddenClass: 'portfolio-selector-hidden',
            progressbarFillClass: 'portfolio-selector-progressbar-fill',
            clickableClass: 'portfolio-selector-clickable',
            dynamicBullets: true,
            /* renderBullet: function (index, className) {
                return '<li class="'+className+' selector'+index+'" data-target="'+index+'"> <img src="https://saravapars.com/wp-content/themes/saravapars/images/'+index+'.svg" class="portfolio-icon"><div class="progress-bar bar'+index+'"></div></li>';
            } */
            renderBullet: function (index, className) {
                console.log()
                return '<li class="' + className + ' selector' + index + '" data-target="' + index + '"> <img src="' + $('.portfolio-slide:nth-child(' + (index + 1) + ')').data('paginationImage') + '" class="portfolio-icon svg-rep"></li>';
            }
        },
        breakpoints: {
            // when window width is <= 320px
            425: {
                simulateTouch: true,
                allowTouchMove: true,
                autoHeight: true,
                pagination: {
                    clickable: false,
                },
                navigation: {
                    nextEl: '.portfolio-slide-next',
                    prevEl: '.portfolio-slide-prev',
                },
            },
            768: {
                simulateTouch: true,
                allowTouchMove: true,
            },
        }
    });
    /*
    * Replace all SVG images with inline SVG
    */
    jQuery('img.svg-rep').each(function () {
        var $img = jQuery(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        jQuery.get(imgURL, function (data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');
            // Add replaced image's ID to the new SVG
            if (typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if (typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }
            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');
            $svg = $svg.removeAttr('width');
            $svg = $svg.removeAttr('height');

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');

    });

    $(window).bind('resize', function () {
        $portfoSlider.update();
    });
})


$(window).bind("scroll", function () { $(window).scrollTop() > 45 ? function ()
     { $(".header-wrapper").addClass("fixed"), $(".main-wrapper").addClass("header-fixed") }() : function () { $(".header-wrapper").removeClass("fixed"), $(".main-wrapper").removeClass("header-fixed") }() }), $(document).ready(function () { $("a.noclick, .noclick > a, .current-lang > a").click(function (e) { e.preventDefault() }), jQuery(".canvas-overlay").click(function () { jQuery(".menu-toggle").click() }), jQuery(".menu-toggle").click(function (e) { e.preventDefault(), jQuery(this).toggleClass("open"), jQuery(".header-section,html,body").toggleClass("canvas-open main-menu") }), window.__forceSmoothScrollPolyfill__ = !0, $(".banner-scroll").click(function () { document.querySelector(".story-section").scrollIntoView({ behavior: "smooth" }) }), $(".smoothScroll").click(function (e) { e.preventDefault() }) 
});

document.addEventListener("DOMContentLoaded", function() {
    document.querySelector(".about-story-desc-button").addEventListener("click", function() {
        document.querySelector(".about-story-desc-wrapper").style.maxHeight = '1000px';
        this.style.display = 'none';
    });
});

document.addEventListener("DOMContentLoaded", function() {
    var accordions = document.querySelectorAll(".accordion");
    var items = document.querySelectorAll(".about-investment-strategy-items");

    accordions.forEach(function(accordion) {
        accordion.addEventListener("click", function(event) {
            event.preventDefault(); 
            this.classList.toggle("open");
            items.forEach(function(item) {
                item.classList.toggle("box-open");
            });
        });
    });
});


/*<!-- Timeline Swiper--> */
document.addEventListener("DOMContentLoaded", function() {
    var timelineSwiper = new Swiper(".timeline-slider", {
        loop: false,
        simulateTouch: false,
        allowTouchMove: false,
        passiveListeners: false,
        noSwiping: true,
        preloadImages: true,
        speed: 1600,
        direction: 'horizontal',
        on: {
            slideChangeTransitionEnd: function () {
                if (timelineController2) {
                    timelineController2.slideTo(this.activeIndex);
                }
            }
        },
        breakpoints: {
            425: {
                simulateTouch: true,
                allowTouchMove: true,
                passiveListeners: true,
                noSwiping: false,
            },
        }
    });

    var scrollContainer = new Swiper('.scroll-container', {
        direction: 'vertical',
        slidesPerView: 'auto',
        freeMode: true,
        scrollbar: {
            el: '.scroll-container-scrollbar',
        },
        mousewheel: true,
    });

    var timelineController = new Swiper('.timeline-controller', {
        direction: 'vertical',
        centeredSlides: true,
        simulateTouch: true,
        loop: false,
        passiveListeners: true,
        freeMode: true,
        allowTouchMove: true,
        slidesPerView: 6,
        slidesPerGroup: 1,
        slidesOffsetBefore: -200,
        height: 500,
        width: 600,
        navigation: {
            nextEl: '.timelineController-next',
            prevEl: '.timelineController-prev',
        },
        on: {
            init: function () {
                document.querySelectorAll('.timeline-controller-slide.swiper-slide-active').forEach(function(slide) {
                    slide.classList.add('partActive');
                });
            },
        }
    });

    var timelineController2 = new Swiper('.timeline-controller2', {
        direction: 'horizontal',
        centeredSlides: true,
        simulateTouch: true,
        loop: false,
        passiveListeners: true,
        allowTouchMove: true,
        slidesPerView: 1,
        slidesPerGroup: 1,
        speed: 600,
        navigation: {
            nextEl: '.timelineController2-next',
            prevEl: '.timelineController2-prev',
        },
        on: {
            init: function () {
                document.querySelectorAll('.timeline-controller2-slide.swiper-slide-active').forEach(function(slide) {
                    slide.classList.add('partActive');
                });
            },
            slideChange: function () {
                var target = this.activeIndex;
                if (timelineSwiper) {
                    timelineSwiper.slideTo(target);
                }
            }
        },
    });

    document.querySelectorAll('.timeline-controller-slide').forEach(function(slide) {
        slide.addEventListener('click', function() {
            var target = this;
            if (!target.classList.contains('partActive')) {
                document.querySelectorAll('.partActive').forEach(function(activeSlide) {
                    activeSlide.classList.remove('partActive');
                });
                target.classList.add('partActive');
                var targetSlide = parseInt(target.getAttribute('data-target'), 10);
                if (timelineController && !isNaN(targetSlide)) {
                    timelineController.slideTo(targetSlide);
                }
                if (timelineSwiper && !isNaN(targetSlide)) {
                    timelineSwiper.slideTo(targetSlide);
                }
            }
        });
    });

    document.querySelectorAll('.timelineController-prev, .timelineController-next').forEach(function(button) {
        button.addEventListener('click', function() {
            document.querySelectorAll('.timeline-controller-slide.partActive').forEach(function(activeSlide) {
                activeSlide.classList.remove('partActive');
            });
            if (timelineController) {
                var activeSlide = timelineController.slides[timelineController.activeIndex];
                if (activeSlide) {
                    activeSlide.classList.add('partActive');
                }
                timelineSwiper.slideTo(timelineController.activeIndex);
            }
        });
    });
});


/*<!-- Counter--> */
document.addEventListener("DOMContentLoaded", function() {
    var optionsFA = {
        useEasing: true,
        useGrouping: true,
        separator: ',',
        decimal: '/',
        numerals: ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'],
    };
    var optionsEN = {
        useEasing: true,
        useGrouping: true,
        decimal: '.',
        separator: ',',
    };
    var isPersian = true;

    var counter0Elem = document.querySelector('.portfo-body-stat-value0');
    var counter1Elem = document.querySelector('.portfo-body-stat-value1');
    var counter2Elem = document.querySelector('.portfo-body-stat-value2');
    var counter3Elem = document.querySelector('.portfo-body-stat-value3');

    var counter0 = new CountUp(counter0Elem, 0, 100, 0, 2.5, optionsFA);
    var counter1 = new CountUp(counter1Elem, 0, 100, 0, 3.5, optionsFA);
    var counter2 = new CountUp(counter2Elem, 0, 1000, 0, 2.5, optionsFA);
    var counter3 = new CountUp(counter3Elem, 0, 10.10, 2, 2.5, optionsFA);

    function startToCount() {
        if (!counter0.error) {
            counter0.start();
        } else {
            console.error(counter0.error);
        }
        if (!counter1.error) {
            counter1.start();
        } else {
            console.error(counter1.error);
        }
        if (!counter2.error) {
            counter2.start();
        } else {
            console.error(counter2.error);
        }
        if (!counter3.error) {
            counter3.start();
        } else {
            console.error(counter3.error);
        }
    }

    function isVisible(el) {
        var rect = el.getBoundingClientRect();
        var viewHeight = Math.max(document.documentElement.clientHeight, window.innerHeight);
        return !(rect.bottom < 0 || rect.top - viewHeight >= 0);
    }

    var portfoBodyStats = document.querySelector('.portfo-body-stats');

    if (isVisible(portfoBodyStats)) {
        setTimeout(startToCount, 1000);
    } else {
        window.addEventListener('scroll', function onScroll() {
            if (isVisible(portfoBodyStats)) {
                setTimeout(startToCount, 1000);
                window.removeEventListener('scroll', onScroll);
            }
        });
    }
});

/*<!-- Swiper Gallary--> */
document.addEventListener("DOMContentLoaded", function () {
    var portfoSlideshow = new Swiper('.portfo-body-slideshow-slider', {
        slidesPerView: 2,
        spaceBetween: 12,
        loop: true,
        centeredSlides: true,
        effect: 'coverflow',
        init: false,
        preloadImages: true,
        lazy: {
            loadPrevNext: true,
            loadPrevNextAmount: 3,
        },
        slideToClickedSlide: true,
        coverflowEffect: {
            rotate: 0,
            slideShadows: true,
            depth: 300,
            modifier: 1.6
        },
        navigation: {
            nextEl: '.portfo-body-slideshow-next',
            prevEl: '.portfo-body-slideshow-prev',
        },
        on: {
            init: function () {
                portfoSlideshow.update();
            }
        },
        breakpoints: {
            425: {
                slidesPerView: 1.5,
            },
        }
    });
    portfoSlideshow.init();

    var portfoReflectSlider = new Swiper('.portfo-body-reflect-slider', {
        slidesPerView: 1,
        loop: false,
        simulateTouch: false,
        allowTouchMove: false,
        passiveListeners: true,
        noSwiping: true,
        preloadImages: true,
        pagination: {
            el: '.reflect-pagination',
            type: 'bullets',
            clickable: true,
        },
    });
});






